 /* ***************************************************************************+
 * ITX package (cnrg.itx) for telephony application programming.              *
 * Copyright (c) 1999  Cornell University, Ithaca NY.                         *
 * A copy of the license is distributed with this package.  Look in the docs  *
 * directory, filename GPL.  Contact information: bergmark@cs.cornell.edu     *
 ******************************************************************************/

package cnrg.itx.signal.SignalEvent;

import cnrg.itx.datax.Connection;
import cnrg.itx.signal.*;

/** This class represents an event generated when a dial sequence failed and the call needs to
 *  be aborted.
 */
public class AbortSignalEvent extends SignalEvent { 
	
	/**  Reason why the call is being aborted  **/
	private String myAbortReason;
	/**  Data exchange connection that is being aborted  **/
	private Connection myOldConn;
	
	/**
	 * constructor for an AbortSignalEvent
	 * @param p_conn the connection given to signaling if the onInvite function accepts with accept(Connection);
	 * @param p_abortReason the reason for the abortion
	 */
	public AbortSignalEvent(InvitePacket ip, Connection c, String reason){
		super(ip);
		myOldConn = c;
		myAbortReason = reason;
	}
	
	/**
	 * @return the old Connection object
	 */
	public Connection getConnection() {
		return myOldConn;
	}
	
	/**
	 * @return the abort reason
	 */
	public String getAbortReason() {
		return myAbortReason;
	}
}
